new const NINTENDOMOD_PRINCESS_PLUGIN[] = "Nintendo Mod X Princess"
new const NINTENDOMOD_PRINCESS_VERSION[] = "2.2.1"
new const NINTENDOMOD_PRINCESS_AUTHOR[] = "Soloist/Mephisto"

/*
	1st Passive: Umbrella
		* Lower gravity.
	2nd Passive: Love
		* The more mates around you, the higher the healing rate for all.
	Skill 1: Slap
		* Slap your foe with your glove.
	Skill 2: Charm
		* Chance to lull your enemy with your divine beauty.
	Skill 3: Group Hug
		* Heal you and your nearby friends with the power of love.
	PowerUp: Cry for Help!
		* When in trouble become small and cry for help! Brings forth a tide of friendly creatures to rain down on your enemy.

	Based on Soloist's original source code Princess v1.3, updated by Mephisto
	Version 2.2.1
	Last Updated On 06/09/09

	*************************************************************************************

	Changelog
		Version 2.2.1
			* mushroom entities removed on disconnect
			* mushroom pev native error fixed
		Version 2.2
			* mushroom entities removed correctly
		Version 2.1.3
			* PowerUp time at lvl 6 reduced to 4 sec
		Version 2.1.2
			* plugin title changed
		Version 2.1.1
			* id error in MushroomHelp fixed
		Version 2.1
			* hitbox exploit fixed
		Version 2.0.1
			* 2nd Passive Love fixed
		Version 2.0
			* godmode time decreased when a player was slapped
			* hitbox fixed for mini model (only stomach)
			* healing skill fixed, now heals to a player's full max health
			* PowerUp changed to what it actually was intended to be: you get small and some damaging mushroom friends spawn around you
			* skills have four levels now, PowerUp has three levels
			* lvl cap increased to 15
			* 2nd passive skill added
		Version 1.3
			* Fixed powerup bug
		Version 1.2
			* Fixed where powerup would random turn on people
		Version 1.1
			* Fixed Group Hug not healing teammates
			* Made Powerup glow team color
		Version 1.0
			* Release of the plugin
*/

#include <amxmodx>
#include <cstrike>
#include <fun>
#include <engine>
#include <fakemeta>
#include <nintendomod>

new const Float:PRINCESS_JUMPGRAV[11] = {775.0, 750.0, 725.0, 700.0, 675.0, 650.0, 625.0, 600.0, 500.0, 400.0, 350.0};
new const Float:PRINCESS_LOVENUM[5] = {0.5, 1.0, 1.5, 2.0, 2.5};
new const PRINCESS_MUSHROOMNUM[3] = {40, 50, 60};
new const PRINCESS_MUSHROOMDMG[3] = {3, 4, 5};
new const Float:PRINCESS_CRYTIME[3] = {4.0, 6.0, 7.0};
new const Float:PRINCESS_SLAPPROB[4] = {0.002, 0.01, 0.03, 0.05};
new const Float:PRINCESS_SLAPDMG[4] = {75.0, 50.0, 25.0, 15.0};
new const Float:PRINCESS_CHARMPROB[4] = {0.005, 0.01, 0.02, 0.05};
new const Float:PRINCESS_GROUPHUGHEALTH[4] = {1.0, 2.0, 3.0, 4.0}

new charName[] = "Princess";
new passiveName[] = "Umbrella";
new passive2Name[] = "Love";
new skill1Name[] = "Slap";
new skill2Name[] = "Charm";
new skill3Name[] = "Group Hug";
new powerupName[] = "Cry for Help!";
new initName[] = "Princess_Init";
new keyDownName[] = "Princess_CryForHelp";

new passiveHelp[] = "Lower gravity.";
new passive2Help[] = "The more mates around you, the higher the healing rate for all.";
new skill1Help[] = "Slap your foe with your glove.";
new skill2Help[] = "Chance to lull your enemy with your divine beauty.";
new skill3Help[] = "Heal you and your nearby friends with the power of love.";
new powerupHelp[] = "When in trouble become small and cry for help! Brings forth a tide of friendly creatures to rain down on your enemy.";

new PlayerLevel[33];
new PlayerSkill1[33];
new PlayerSkill2[33];
new PlayerSkill3[33];
new PlayerPowerUp[33];

new Mushroom[33][60];
new bool:PowerActive[33];
new healthSpr;

public plugin_init()
{
	if(is_plugin_loaded("Nintendo Mod Xtended") == -1)
	{
		server_print("**********************************");
		server_print("*** Nintendo Mod is not loaded ***");
		server_print("**********************************");
		pause("ae");
		return;
	}

	register_plugin(NINTENDOMOD_PRINCESS_PLUGIN, NINTENDOMOD_PRINCESS_VERSION, NINTENDOMOD_PRINCESS_AUTHOR);

	register_cvar("NintendoMod_Princess_Version", NINTENDOMOD_PRINCESS_VERSION, FCVAR_SERVER|FCVAR_SPONLY);

	register_event("ResetHUD", "ResetHUD", "b");
	register_logevent("RoundStart", 2, "1=Round_Start")

	register_forward(FM_Touch, "Princess_Slap");
	register_forward(FM_PlayerPreThink, "Princess_Charm");

	Nintendo_RegisterChar(charName, passiveName, passive2Name, skill1Name, skill2Name, skill3Name, powerupName, initName);
	Nintendo_RegisterHelp(charName, passiveHelp, passive2Help, skill1Help, skill2Help, skill3Help, powerupHelp);
	Nintendo_RegisterKeyDown(charName, keyDownName);

	register_srvcmd(initName, initName);
	register_srvcmd(keyDownName, keyDownName);
}

public plugin_precache()
{
	engfunc(EngFunc_PrecacheSound, "nintendomod/princess_mrhit.wav");
	engfunc(EngFunc_PrecacheModel, "models/player/princess_smallmodel/princess_smallmodel.mdl");
	engfunc(EngFunc_PrecacheModel, "models/nintendomod/princess_mushroom.mdl");
	healthSpr = engfunc(EngFunc_PrecacheModel, "sprites/nintendomod/princess_health.spr");
}

public client_connect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);

	return PLUGIN_CONTINUE;
}

public client_disconnect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new ent;
	InitPlayer(id);
	remove_task(id);
	while((ent = find_ent_by_owner(-1, "mushroom", id)))
		engfunc(EngFunc_RemoveEntity, ent);

	return PLUGIN_CONTINUE;
}

public InitPlayer(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	PlayerLevel[id] = 0;
	PlayerSkill1[id] = 0;
	PlayerSkill2[id] = 0;
	PlayerSkill3[id] = 0;
	PlayerPowerUp[id] = 0;

	return PLUGIN_CONTINUE;
}

public Princess_Init()
{
	new temp[33];
	read_argv(1, temp, 32);
	new id = str_to_num(temp);

	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	read_argv(2, temp, 32);
	new index  = str_to_num(temp);

	if(index == 0)
	{
		read_argv(3, temp, 32);
		new level = str_to_num(temp);
		read_argv(4, temp, 32);
		new skill1 = str_to_num(temp);
		read_argv(5, temp, 32);
		new skill2 = str_to_num(temp);
		read_argv(6, temp, 32);
		new skill3 = str_to_num(temp);
		read_argv(7, temp, 32);
		new powerup = str_to_num(temp);

		PlayerLevel[id] = level;
		PlayerSkill1[id] = skill1;
		PlayerSkill2[id] = skill2;
		PlayerSkill3[id] = skill3;
		PlayerPowerUp[id] = powerup;
	}
	else
	{
		read_argv(3, temp, 32);
		new value = str_to_num(temp);

		switch(index)
		{
			case 1: PlayerLevel[id] = value
			case 2: PlayerSkill1[id] = value;
			case 3: PlayerSkill2[id] = value;
			case 4: PlayerSkill3[id] = value;
			case 5: PlayerPowerUp[id] = value;
		}
	}

	ResetHUD(id);

	return PLUGIN_CONTINUE;
}

public RoundStart()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	new ent;
	
	while((ent = find_ent_by_class(-1,"mushroom")))
		engfunc(EngFunc_RemoveEntity, ent);

	return PLUGIN_CONTINUE;
}

public ResetHUD(id)
{
	if(!Nintendo_IsValidPlayer(id))
		return PLUGIN_CONTINUE;
	cs_reset_user_model(id);
	set_user_hitzones(0, id);

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id, true))
		return PLUGIN_HANDLED;

	Nintendo_SetGlow(id);
	PowerActive[id] = false;

	Princess_Passive(id);
	// remove Princess' healing tasks before
	remove_task(id);
	Princess_GroupHug(id);

	return PLUGIN_CONTINUE;
}

public Princess_Passive(id) // Passive
{
	if (!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id, true))
		return PLUGIN_HANDLED;

	if(PlayerLevel[id] > 10)
	{
		new players[32], num, Float:enemies = 0.0;
		get_players(players, num);

		for(new i = 0; i < num; i++)
			if(Nintendo_IsValidPlayer(players[i]) && players[i] != id)
				if(get_user_team(id) != get_user_team(players[i]))
					enemies += 1.0;
		Nintendo_SetGravity(id, PRINCESS_JUMPGRAV[10]);
		Nintendo_SetHealth(id, 100.0 + enemies*5.0, true);
	}
	else
		Nintendo_SetGravity(id, PRINCESS_JUMPGRAV[PlayerLevel[id]]);

	return PLUGIN_CONTINUE;
}

public Princess_Slap(victim, attacker) // Skill 1
{
	if(!Nintendo_Active() || !Nintendo_HasChar(attacker, charName) || !Nintendo_IsValidPlayer(victim, true) || !Nintendo_IsValidPlayer(attacker, true))
		return PLUGIN_HANDLED;

	if(PlayerSkill1[attacker] > 0)
	{
		if(Nintendo_TeamKill(victim, attacker))
		{
			new Float:randomnumber = random_float(0.0, 1.0);
			if(randomnumber <= PRINCESS_SLAPPROB[PlayerSkill1[attacker] - 1])
			{
				new curHealth = pev(victim, pev_health);
				if(curHealth <= PRINCESS_SLAPDMG[PlayerSkill1[attacker] - 1])
					Nintendo_SetHealth(victim, 1.0, false);
				else
					Nintendo_SetHealth(victim, PRINCESS_SLAPDMG[PlayerSkill1[attacker] - 1], false);

				new Float:vectors[3]
				vectors[0] = random_float(-900.0, 900.0);
				vectors[1] = random_float(-900.0, 900.0);
				vectors[2] = random_float(-900.0, 900.0);
				set_pev(victim, pev_punchangle, vectors);

				vectors[0] = random_float(200.0, 3500.0);
				vectors[1] = random_float(200.0, 3500.0);
				vectors[2] = random_float(200.0, 3500.0);
				set_pev(victim, pev_velocity, vectors);

				set_pev(victim, pev_takedamage, 0.0);
				set_task(2.5, "Princess_SlapRemoveGod", victim);

				switch (random_num(1, 4))
				{
					case 1: emit_sound(victim, CHAN_VOICE, "player/bhit_flesh-3.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
					case 2: emit_sound(victim, CHAN_VOICE, "player/bhit_flesh-2.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
					case 3: emit_sound(victim, CHAN_VOICE, "player/pl_die1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
					case 4: emit_sound(victim, CHAN_VOICE, "player/pl_pain6.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
				}
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public Princess_SlapRemoveGod(id)
	set_pev(id, pev_takedamage, 2.0);

public Princess_Charm(id) // Skill 2
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id, true))
		return PLUGIN_HANDLED;

	if(PlayerSkill2[id] > 0)
	{
		new victim, body
		get_user_aiming(id, victim, body);
		if(Nintendo_IsValidPlayer(victim))
		{
			if(get_user_team(id) != get_user_team(victim))
			{
				new Float:randomnumber = random_float(0.0, 1.0);
				if(randomnumber <= PRINCESS_CHARMPROB[PlayerSkill2[id] - 1])
				{
					new Float:velocity[3];
					new idOrigin[3], vicOrigin[3];

					pev(victim, pev_origin, vicOrigin);
					pev(id, pev_origin, idOrigin);

					new distance = get_distance(idOrigin, vicOrigin);

					if(distance > 50)
					{
						new Float:length = distance / 500.0;

						velocity[0] = float((idOrigin[0] - vicOrigin[0])) / length;
						velocity[1] = float((idOrigin[1] - vicOrigin[1])) / length;
						velocity[2] = float((idOrigin[2] - vicOrigin[2])) / length;
					}
					else
					{
						velocity[0] = 0.0;
						velocity[1] = 0.0;
						velocity[2] = 0.0;
					}

					set_pev(victim, pev_velocity, velocity);
				}
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public Princess_GroupHug(id) // Skill 3
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id, true))
		return PLUGIN_HANDLED;

	if(PlayerSkill3[id] > 0)
	{
		new Float:newHealth, curHealth, Float:hp_bonus = 0.0;
		new healer[3];
		new players[32], num, player;
		get_players(players, num);
		get_user_origin(id, healer);

		if(PlayerLevel[id] > 10)
			for(new i = 0; i < num; i++)
			{
				player = players[i];
				if(Nintendo_IsValidPlayer(player, true) && player != id)
					if(get_user_team(id) == get_user_team(player))
					{
						new healed[3];
						get_user_origin(player, healed);
						if(get_distance(healer, healed) <= 500)
							hp_bonus += PRINCESS_LOVENUM[PlayerLevel[id] - 11];
					}
			}

		hp_bonus = float(floatround(hp_bonus));
		curHealth = pev(id, pev_health);

		if(curHealth < pev(id, pev_max_health))
		{
			newHealth = curHealth + PRINCESS_GROUPHUGHEALTH[PlayerSkill3[id] - 1] + hp_bonus;
			if(newHealth > float(pev(id, pev_max_health))) newHealth = float(pev(id, pev_max_health));
			Nintendo_SetHealth(id, newHealth, false);

			Princess_GroupHugSprite(id);
		}

		for(new i = 0; i < num; i++)
		{
			player = players[i];
			if(Nintendo_IsValidPlayer(player, true) && player != id)
			{
				if(get_user_team(id) == get_user_team(player))
				{
					new healed[3];

					get_user_origin(player, healed);
					if(get_distance(healer, healed) <= 500)
					{
						curHealth = pev(player, pev_health);
						if(curHealth < pev(player, pev_max_health))
						{
							newHealth = curHealth + PRINCESS_GROUPHUGHEALTH[PlayerSkill3[id] - 1] + hp_bonus;
							if(newHealth > float(pev(player, pev_max_health))) newHealth = float(pev(player, pev_max_health));
							Nintendo_SetHealth(player, newHealth, false);
							Princess_GroupHugSprite(player);
						}
					}
				}
			}
		}

		set_task(2.0,"Princess_GroupHug", id)
	}

	return PLUGIN_CONTINUE;
}

public Princess_GroupHugSprite(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id, true))
		return PLUGIN_HANDLED;

	message_begin(MSG_ALL, SVC_TEMPENTITY)
	write_byte(124)
	write_byte(id)
	write_coord(50)
	write_short(healthSpr)
	write_short(3)
	message_end()

	return PLUGIN_CONTINUE;
}

public Princess_CryForHelp()
{
	new temp[6]
	read_argv(1, temp, 5)
	new id = str_to_num(temp)

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id, true))
		return PLUGIN_HANDLED;

	if(PlayerPowerUp[id] >= 1)
	{
		Nintendo_PowerUpUsed(id, 1, 30);
		PowerActive[id] = true;
		cs_set_user_model(id, "princess_smallmodel");
		set_user_hitzones(0, id, 8);
		if(get_user_team(id) == 1)
			Nintendo_SetGlow(id, kRenderFxGlowShell, 255, 0, 0, kRenderNormal, 25);
		else
			Nintendo_SetGlow(id, kRenderFxGlowShell, 0, 0, 255, kRenderNormal, 25);
		Nintendo_StatusHUD(id, "You have used a mushroom, so you are small.", 1);

		new Float:origin[3];
		new idOrigin[3];
		get_user_origin(id, idOrigin);
		for(new i=0; i < PRINCESS_MUSHROOMNUM[PlayerPowerUp[id] - 1]; i++)
		{
			origin[0] = float(idOrigin[0]);
			origin[1] = float(idOrigin[1]);
			origin[2] = float(idOrigin[2]);

			Mushroom[id][i] = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"));
			set_pev(Mushroom[id][i], pev_classname, "mushroom");
			if(get_user_team(id) == 1)
				Nintendo_SetGlow(Mushroom[id][i], kRenderFxGlowShell, 255, 0, 0, kRenderNormal, 25);
			else
				Nintendo_SetGlow(Mushroom[id][i], kRenderFxGlowShell, 0, 0, 255, kRenderNormal, 25);
			engfunc(EngFunc_SetModel, Mushroom[id][i], "models/nintendomod/princess_mushroom.mdl");
			engfunc(EngFunc_SetOrigin, Mushroom[id][i], origin);
			set_pev(Mushroom[id][i], pev_effects, 32);
			set_pev(Mushroom[id][i], pev_solid, SOLID_BBOX);
			set_pev(Mushroom[id][i], pev_movetype, MOVETYPE_BOUNCE);
			set_pev(Mushroom[id][i], pev_health, 200.0);
			set_pev(Mushroom[id][i], pev_takedamage, 2.0);
			set_pev(Mushroom[id][i], pev_owner, id);
			set_pev(Mushroom[id][i], pev_framerate, 1.0);
			set_pev(Mushroom[id][i], pev_sequence, 0);

			new Float:mVelocity[3];
			mVelocity[0] = random_float(-300.0, 300.0);
			mVelocity[1] = random_float(-300.0, 300.0);
			mVelocity[2] = random_float(20.0, 150.0);
			set_pev(Mushroom[id][i], pev_velocity, mVelocity);
		}
		set_task(0.5, "Princess_MushroomHelp", id);
		set_task(PRINCESS_CRYTIME[PlayerPowerUp[id] - 1], "Princess_CryForHelpReset", id);
	}

	return PLUGIN_CONTINUE;
}

public Princess_MushroomHelp(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new players[32], num, player;
	get_players(players, num);
	for(new i = 0; i < num; i++)
	{
		player = players[i];
		if(Nintendo_IsValidPlayer(player, true))
		{
			if((get_user_team(id) != get_user_team(player)))
			{
				new vicOrigin[3];
				get_user_origin(player, vicOrigin);
				for(new j=0; j < PRINCESS_MUSHROOMNUM[PlayerPowerUp[id] - 1]; j++)
				{
					new Float:origin[3], mOrigin[3];
					if(!(Mushroom[id][j] > 0) || !pev_valid(Mushroom[id][j]))
						continue;
					pev(Mushroom[id][j], pev_origin, origin);
					mOrigin[0] = floatround(origin[0]);
					mOrigin[1] = floatround(origin[1]);
					mOrigin[2] = floatround(origin[2]);

					new dist = get_distance(vicOrigin, mOrigin);
					if(dist <= 50)
					{
						Nintendo_ExtraDamage(id, player, PRINCESS_MUSHROOMDMG[PlayerPowerUp[id]-1], "Flying Mushroom", 0);
						emit_sound(Mushroom[id][j], CHAN_AUTO, "nintendomod/princess_mrhit.wav", 0.3, ATTN_NORM, 0, PITCH_NORM);
						engfunc(EngFunc_RemoveEntity, Mushroom[id][j]);
						Mushroom[id][j] = 0;
					}
				}
			}
		}
	}
	if(PowerActive[id])
	{
		set_task(0.2, "Princess_MushroomHelp", id);
	}
	
	return PLUGIN_CONTINUE;
}

public Princess_CryForHelpReset(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	Nintendo_SetGlow(id);
	cs_reset_user_model(id);
	set_user_hitzones(0, id);
	PowerActive[id] = false;
	for(new i=0; i < PRINCESS_MUSHROOMNUM[2]; i++)
	{
		if(Mushroom[id][i] > 0 && pev_valid(Mushroom[id][i]))
		{
			emit_sound(Mushroom[id][i], CHAN_AUTO, "nintendomod/princess_mrhit.wav", 0.3, ATTN_NORM, 0, PITCH_NORM);
			engfunc(EngFunc_RemoveEntity, Mushroom[id][i]);
		}
		Mushroom[id][i] = 0;
	}
	Nintendo_StatusHUD(id, "You are back to normal.", 1);

	return PLUGIN_CONTINUE;
}
